<?php
// payment_failure.php
session_start();
$reference = $_GET['ref'] ?? 'N/A';
// Vous pouvez passer des messages d'erreur plus spécifiques si FluxSends les fournit dans le redirect_url
$errorMessage = $_GET['message'] ?? 'Payment could not be processed or was cancelled.';
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Payment Failed!</title>
    <link href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css" rel="stylesheet">
    <style>
        body { background-color: #f8f9fa; display: flex; justify-content: center; align-items: center; min-height: 100vh; }
        .card { max-width: 500px; text-align: center; padding: 30px; border-radius: 8px; box-shadow: 0 0 15px rgba(220, 53, 69, 0.2); border: 1px solid #dc3545; }
        .icon { font-size: 80px; color: #dc3545; margin-bottom: 20px; }
        .btn-primary { background-color: #007bff; border-color: #007bff; }
        .btn-primary:hover { background-color: #0056b3; border-color: #0056b3; }
    </style>
</head>
<body>
    <div class="card">
        <div class="icon">&#10006;</div>
        <h2 class="card-title text-danger">Payment Failed!</h2>
        <p class="card-text">Unfortunately, your payment could not be processed.</p>
        <p class="card-text text-danger">Reason: <?php echo htmlspecialchars($errorMessage); ?></p>
        <p class="card-text">Your transaction reference: <strong><?php echo htmlspecialchars($reference); ?></strong></p>
        <a href="index.php" class="btn btn-primary mt-3">Try Again</a>
        <a href="index.php" class="btn btn-outline-secondary mt-2">Go to Homepage</a>
    </div>
</body>
</html>