<?php
// index.php
require_once 'config.php'; // Pour accéder aux constantes

session_start();
$errorMessage = '';
if (isset($_SESSION['error'])) {
    $errorMessage = $_SESSION['error'];
    unset($_SESSION['error']);
}

$old_input = $_SESSION['old_input'] ?? [];
unset($_SESSION['old_input']);

function old_value($key, $default = '') {
    global $old_input;
    return htmlspecialchars($old_input[$key] ?? $default);
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Make a Payment</title>
    <link href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css" rel="stylesheet">
    <style>
        body { background-color: #f8f9fa; }
        .container { max-width: 600px; margin-top: 50px; background-color: #ffffff; padding: 30px; border-radius: 8px; box-shadow: 0 0 10px rgba(0, 0, 0, 0.1); }
        .form-group label { font-weight: bold; }
        .btn-primary { background-color: #007bff; border-color: #007bff; }
        .btn-primary:hover { background-color: #0056b3; border-color: #0056b3; }
        .text-danger { color: #dc3545; font-size: 0.875em; }
    </style>
</head>
<body>
    <div class="container">
        <h2 class="mb-4 text-center">Make a Payment with FluxSends</h2>

        <?php if (!empty($errorMessage)): ?>
            <div class="alert alert-danger">
                <?php echo $errorMessage; ?>
            </div>
        <?php endif; ?>

        <form action="process_payment.php" method="POST">
            <div class="form-group">
                <label for="first_name">First Name:</label>
                <input type="text" class="form-control" id="first_name" name="first_name" value="<?php echo old_value('first_name'); ?>" required>
            </div>

            <div class="form-group">
                <label for="last_name">Last Name:</label>
                <input type="text" class="form-control" id="last_name" name="last_name" value="<?php echo old_value('last_name'); ?>" required>
            </div>

            <div class="form-group">
                <label for="email">Email:</label>
                <input type="email" class="form-control" id="email" name="email" value="<?php echo old_value('email'); ?>" required>
            </div>

            <div class="form-group">
                <label for="mobile">Mobile Number:</label>
                <input type="text" class="form-control" id="mobile" name="mobile" value="<?php echo old_value('mobile'); ?>" required>
            </div>
            <div class="form-group">
                <label for="amount">Amount:</label>
                <input type="number" step="0.01" min="0.01" class="form-control" id="amount" name="amount" value="<?php echo old_value('amount'); ?>" required>
            </div>

            <div class="form-group">
                <label for="currency">Currency:</label>
                <select class="form-control" id="currency" name="currency" required>
                    <option value="">Select Currency</option>
                    <?php foreach ($supportedCurrencies as $currencyCode): ?>
                        <option value="<?php echo $currencyCode; ?>" <?php echo (old_value('currency') == $currencyCode) ? 'selected' : ''; ?>>
                            <?php echo $currencyCode; ?>
                        </option>
                    <?php endforeach; ?>
                </select>
            </div>

            <div class="form-group">
                <label for="details">Payment Details (Description):</label>
                <textarea class="form-control" id="details" name="details" rows="3" required><?php echo old_value('details', 'Purchase details'); ?></textarea>
            </div>

            <button type="submit" class="btn btn-primary btn-block">Pay Now</button>
        </form>
    </div>
</body>
</html>