<?php
// fluxsends_webhook.php
require_once 'config.php'; // Toujours nécessaire pour les clés public/secret

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $data = $_POST; // Récupère toutes les données POST

    if (!isset($data['status'], $data['signature'], $data['identifier'], $data['data'])) {
        http_response_code(400); // Bad Request
        error_log(date('Y-m-d H:i:s') . " - FluxSends Webhook: Missing required data in POST. Data: " . print_r($data, true));
        die('Missing data');
    }

    $status = $data['status'];
    $receivedSignature = $data['signature'];
    $identifierFromWebhook = $data['identifier']; // L'IDENTIFIANT REÇU DU WEBHOOK
    $paymentData = $data['data'];

    // Dans ce scénario, on ne peut pas VRAIMENT vérifier si l'identifiant est "le nôtre"
    // car il n'est pas fixe. Cependant, nous l'utilisons pour la signature.
    // Il faudrait que FluxSends fournisse un moyen de valider que cet identifier
    // est autorisé à envoyer des webhooks à votre IPN URL.
    // Pour l'instant, nous faisons confiance à l'identifiant reçu pour le calcul de la signature.
    // C'est un risque si cet identifiant est facilement modifiable par un tiers.

    if (!isset($paymentData['amount']) || !isset($paymentData['reference'])) {
        http_response_code(400); // Bad Request
        error_log(date('Y-m-d H:i:s') . " - FluxSends Webhook: Missing amount or reference in paymentData (data field). Data: " . print_r($paymentData, true));
        die('Missing payment data in "data" field');
    }

    // IMPORTANT : Utiliser l'identifiant reçu du webhook pour générer la signature
    $customKey = $paymentData['amount'] . $identifierFromWebhook;
    $mySignature = strtoupper(hash_hmac('sha256', $customKey , FLUXSENDS_SECRET_KEY));

    // Valider le paiement
    if ($status === "success" && $receivedSignature === $mySignature) {
        $logFile = 'fluxsends_payment_success.log';
        $logMessage = date('Y-m-d H:i:s') . " - SUCCESS: Reference " . $paymentData['reference'] . ", Amount: " . $paymentData['amount'] . " " . $paymentData['currency'] . ", Status: " . $status . " | Identifier: " . $identifierFromWebhook . " | Raw Data: " . print_r($data, true) . "\n";
        file_put_contents($logFile, $logMessage, FILE_APPEND);

        http_response_code(200);
        die('Webhook Received Successfully');

    } else {
        $logFile = 'fluxsends_payment_failed.log';
        $logMessage = date('Y-m-d H:i:s') . " - FAILED/INVALID: Reference " . ($paymentData['reference'] ?? 'N/A') . ", Status: " . $status . ", Received Signature: " . $receivedSignature . ", Expected Signature: " . $mySignature . ", Identifier: " . $identifierFromWebhook . ", Raw Data: " . print_r($data, true) . "\n";
        file_put_contents($logFile, $logMessage, FILE_APPEND);

        http_response_code(200);
        die('Webhook Processed (Failure or Invalid Signature)');
    }
} else {
    http_response_code(405);
    error_log(date('Y-m-d H:i:s') . " - FluxSends Webhook: Method Not Allowed. Received Method: " . $_SERVER['REQUEST_METHOD']);
    die('Method Not Allowed');
}
?>